// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalGvar;
use crate::blobs::{HasBlob, Blob};

/// Represents access to global variable (i.e. `$foo`)
#[repr(C)]
pub struct Gvar {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Gvar {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Gvar")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Gvar {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Gvar {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__gvar__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__gvar__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__gvar__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__gvar__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalGvar {
        unsafe { lib_ruby_parser__external__nodes__gvar__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__gvar__get_name(blob: *const Blob<Gvar>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__gvar__set_name(blob: *mut Blob<Gvar>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__gvar__get_expression_l(blob: *const Blob<Gvar>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__gvar__set_expression_l(blob: *mut Blob<Gvar>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__gvar__into_internal(blob: Blob<Gvar>) -> InternalGvar;
    fn lib_ruby_parser__external__nodes__gvar__drop(blob: *mut Blob<Gvar>);
}

impl InnerNode for Gvar {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "gvar"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_expression_l().print("expression");
    }
}

impl Drop for Gvar {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__gvar__drop(&mut self.blob) }
    }
}
