// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents class variable assignment (i.e. `@@var = 42`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Cvasgn {
    /// Name of the class variable, `String("@@foo")` for `@@foo = 1`
    pub name: String,

    /// Value that is assigned to class variable, `Int("1")` for `@@foo = 1`
    pub value: Option<Box<Node>>,

    /// Location of the class variable name
    ///
    /// ```text
    /// @@foo = 1
    /// ~~~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// @@foo = 1
    ///       ~
    /// ```
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// @@foo = 1
    /// ~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Cvasgn {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Option<Loc>) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalCvasgn {
        let Self { name, value, name_l, operator_l, expression_l,  } = self;
        super::InternalCvasgn { name, value, name_l, operator_l, expression_l,  }
    }
}

impl InnerNode for Cvasgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_maybe_node(self.get_value());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "cvasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(node) = self.get_value().as_ref() { node.inner_ref().print_with_locs() }
        self.get_name_l().print("name");
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}
