// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Const pattern used in pattern matching (e.g. `in A(1, 2)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct ConstPattern {
    /// Constant that is used, `Const("Foo")` for `in For(42)`
    pub const_: Box<Node>,

    /// Inner part of the constant pattern
    ///
    /// `ArrayPattern(vec![ Int("1") ])` for `Foo(1)`
    pub pattern: Box<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// case 1; in Foo(42); end
    ///               ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// case 1; in Foo(42); end
    ///                  ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; in Foo(42); end
    ///            ~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl ConstPattern {
    // getters

    /// Returns `const_` field
    pub fn get_const(&self) -> &Box<Node> {
        &self.const_
    }

    /// Returns `pattern` field
    pub fn get_pattern(&self) -> &Box<Node> {
        &self.pattern
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `const_` field
    pub fn set_const(&mut self, const_: Box<Node>) {
        self.const_ = const_;
    }

    /// Sets `pattern` field
    pub fn set_pattern(&mut self, pattern: Box<Node>) {
        self.pattern = pattern;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalConstPattern {
        let Self { const_, pattern, begin_l, end_l, expression_l,  } = self;
        super::InternalConstPattern { const_, pattern, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for ConstPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_const());
        result.push_node(self.get_pattern());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "const_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_const().inner_ref().print_with_locs();
        self.get_pattern().inner_ref().print_with_locs();
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
