// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `Complex` literal (that returns an `Complex` number)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Complex {
    /// Value of the complex literal, returned as a `String`, `String("1i")` for `1i`
    pub value: String,

    /// Location of the `-` (but not `+`) operator. `+` is a part of the literal:
    /// 1. `+1i` is `String("+1i")` with `operator = None`
    /// 2. `-1i` is `String("1i")` with `operator = String("-")`
    ///
    /// ```text
    /// -1i
    /// ~
    /// ```
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// -1i
    /// ~~~
    /// ```
    pub expression_l: Loc,

}

impl Complex {
    // getters

    /// Returns `value` field
    pub fn get_value(&self) -> &String {
        &self.value
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `value` field
    pub fn set_value(&mut self, value: String) {
        self.value = value;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Option<Loc>) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalComplex {
        let Self { value, operator_l, expression_l,  } = self;
        super::InternalComplex { value, operator_l, expression_l,  }
    }
}

impl InnerNode for Complex {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "complex"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}
