// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a class definition (using a `class` keyword, `Class.new` is just a method call)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Class {
    /// Name of the class, `String("Foo")` for `class Foo; end`
    pub name: Box<Node>,

    /// Superclass. Can be an expression in cases like `class A < (obj.foo + 1); end`
    ///
    /// `None` if no explicit superclass given (i.e. `class Foo; end`)
    pub superclass: Option<Box<Node>>,

    /// Body of the method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `class` keyword.
    ///
    /// ```text
    /// class Foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `<` operator
    ///
    /// ```text
    /// class A < B; end
    ///         ~
    /// ```
    ///
    /// `None` if there's no explicit superclass given.
    pub operator_l: Option<Loc>,

    /// Location of the `end` keyword.
    ///
    /// ```text
    /// class Foo; end
    ///            ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// class Foo; end
    /// ~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Class {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &Box<Node> {
        &self.name
    }

    /// Returns `superclass` field
    pub fn get_superclass(&self) -> &Option<Box<Node>> {
        &self.superclass
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: Box<Node>) {
        self.name = name;
    }

    /// Sets `superclass` field
    pub fn set_superclass(&mut self, superclass: Option<Box<Node>>) {
        self.superclass = superclass;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Option<Loc>) {
        self.operator_l = operator_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalClass {
        let Self { name, superclass, body, keyword_l, operator_l, end_l, expression_l,  } = self;
        super::InternalClass { name, superclass, body, keyword_l, operator_l, end_l, expression_l,  }
    }
}

impl InnerNode for Class {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_name());
        result.push_maybe_node_or_nil(self.get_superclass());
        result.push_maybe_node_or_nil(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "class"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_name().inner_ref().print_with_locs();
        if let Some(node) = self.get_superclass().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
