// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a constant assignment (i.e. `A = 1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Casgn {
    /// Scope where the constant is defined:
    /// 1. `Some(Const("A"))` for `A::B = 1`
    /// 2. `None` if it's defined in the current scope (i.e. `A = 1`)
    /// 3. `Some(Cbase)` if it's defined in the global scope (i.e. `::A = 1`)
    pub scope: Option<Box<Node>>,

    /// Name of the constant, `String("A")` for `A = 1`
    pub name: String,

    /// Value that is assigned to a constant, `Int("1")` for `A = 1`.
    ///
    /// **Note**: `None` if constant assignment is a part of the multi-assignment.
    /// In such case `value` belongs to `Masgn` node of the multi-assignment.
    pub value: Option<Box<Node>>,

    /// Location of the `::` operator
    ///
    /// ```text
    /// A::B = 1
    ///  ~~
    ///
    /// ::A = 1
    /// ~~
    /// ```
    ///
    /// `None` if the constant is defined in the current scope
    pub double_colon_l: Option<Loc>,

    /// Location of the constant name
    ///
    /// ```text
    /// A::CONST = 1
    ///    ~~~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// A = 1
    ///   ~
    /// ```
    ///
    /// `None` if constant assignment is a part of the multi-assignment.
    /// In such case `=` belongs to a `Masgn` node
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// A = 1
    /// ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Casgn {
    // getters

    /// Returns `scope` field
    pub fn get_scope(&self) -> &Option<Box<Node>> {
        &self.scope
    }

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    /// Returns `double_colon_l` field
    pub fn get_double_colon_l(&self) -> &Option<Loc> {
        &self.double_colon_l
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `scope` field
    pub fn set_scope(&mut self, scope: Option<Box<Node>>) {
        self.scope = scope;
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    /// Sets `double_colon_l` field
    pub fn set_double_colon_l(&mut self, double_colon_l: Option<Loc>) {
        self.double_colon_l = double_colon_l;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Option<Loc>) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalCasgn {
        let Self { scope, name, value, double_colon_l, name_l, operator_l, expression_l,  } = self;
        super::InternalCasgn { scope, name, value, double_colon_l, name_l, operator_l, expression_l,  }
    }
}

impl InnerNode for Casgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_scope());
        result.push_str(self.get_name());
        result.push_maybe_node(self.get_value());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "casgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_scope().as_ref() { node.inner_ref().print_with_locs() }

        if let Some(node) = self.get_value().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(loc) = self.get_double_colon_l().as_ref() { loc.print("double_colon") }
        self.get_name_l().print("name");
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}
