// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;

use super::internal::InternalCase;
use crate::blobs::{HasBlob, Blob};

/// Represents a `case` statement (for pattern matching see `CaseMatch` node)
#[repr(C)]
pub struct Case {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Case {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Case")
            .field("expr", &self.get_expr())
            .field("when_bodies", &self.get_when_bodies())
            .field("else_body", &self.get_else_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("else_l", &self.get_else_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Case {
    fn eq(&self, other: &Self) -> bool {
        if self.get_expr() != other.get_expr() {
            return false
        }
        if self.get_when_bodies() != other.get_when_bodies() {
            return false
        }
        if self.get_else_body() != other.get_else_body() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_else_l() != other.get_else_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Case {
    // getters
    /// Returns `expr` field
    pub fn get_expr(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_expr(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `when_bodies` field
    pub fn get_when_bodies(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_when_bodies(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `else_body` field
    pub fn get_else_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_else_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_else_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `expr` field
    pub fn set_expr(&mut self, expr: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__case__set_expr(&mut self.blob, expr.into_blob()) }
    }
    /// Sets `when_bodies` field
    pub fn set_when_bodies(&mut self, when_bodies: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__case__set_when_bodies(&mut self.blob, when_bodies.into_blob()) }
    }
    /// Sets `else_body` field
    pub fn set_else_body(&mut self, else_body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__case__set_else_body(&mut self.blob, else_body.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__case__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__case__set_else_l(&mut self.blob, else_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__case__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__case__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalCase {
        unsafe { lib_ruby_parser__external__nodes__case__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__case__get_expr(blob: *const Blob<Case>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__case__set_expr(blob: *mut Blob<Case>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__case__get_when_bodies(blob: *const Blob<Case>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__case__set_when_bodies(blob: *mut Blob<Case>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__case__get_else_body(blob: *const Blob<Case>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__case__set_else_body(blob: *mut Blob<Case>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__case__get_keyword_l(blob: *const Blob<Case>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__case__set_keyword_l(blob: *mut Blob<Case>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__case__get_else_l(blob: *const Blob<Case>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__case__set_else_l(blob: *mut Blob<Case>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__case__get_end_l(blob: *const Blob<Case>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__case__set_end_l(blob: *mut Blob<Case>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__case__get_expression_l(blob: *const Blob<Case>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__case__set_expression_l(blob: *mut Blob<Case>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__case__into_internal(blob: Blob<Case>) -> InternalCase;
    fn lib_ruby_parser__external__nodes__case__drop(blob: *mut Blob<Case>);
}

impl InnerNode for Case {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_expr());
        result.push_nodes(self.get_when_bodies());
        result.push_maybe_node_or_nil(self.get_else_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "case"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_expr().as_ref() { node.inner_ref().print_with_locs() }
        for node in self.get_when_bodies().iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.get_else_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_else_l().as_ref() { loc.print("else") }
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Case {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__case__drop(&mut self.blob) }
    }
}
