// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalBlockarg;
use crate::blobs::{HasBlob, Blob};

/// Represents a `&blk` argument in the method definition (but not in the method call, see `BlockPass`)
#[repr(C)]
pub struct Blockarg {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Blockarg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Blockarg")
            .field("name", &self.get_name())
            .field("operator_l", &self.get_operator_l())
            .field("name_l", &self.get_name_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Blockarg {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_name_l() != other.get_name_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Blockarg {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__blockarg__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__blockarg__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__blockarg__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__blockarg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__blockarg__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__blockarg__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__blockarg__set_name_l(&mut self.blob, name_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__blockarg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalBlockarg {
        unsafe { lib_ruby_parser__external__nodes__blockarg__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__blockarg__get_name(blob: *const Blob<Blockarg>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__blockarg__set_name(blob: *mut Blob<Blockarg>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__blockarg__get_operator_l(blob: *const Blob<Blockarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__blockarg__set_operator_l(blob: *mut Blob<Blockarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__blockarg__get_name_l(blob: *const Blob<Blockarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__blockarg__set_name_l(blob: *mut Blob<Blockarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__blockarg__get_expression_l(blob: *const Blob<Blockarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__blockarg__set_expression_l(blob: *mut Blob<Blockarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__blockarg__into_internal(blob: Blob<Blockarg>) -> InternalBlockarg;
    fn lib_ruby_parser__external__nodes__blockarg__drop(blob: *mut Blob<Blockarg>);
}

impl InnerNode for Blockarg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "blockarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_operator_l().print("operator");
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Blockarg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__blockarg__drop(&mut self.blob) }
    }
}
