// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an arguments list
///
/// `Args(vec![Arg("a"), Optarg("b", Int("1"))])` in `def m(a, b = 1); end`
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Args {
    /// List of arguments
    pub args: Vec<Node>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(a, b = 1, c:, &blk); end
    ///      ~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// def m(a, b = 1, c:, &blk); end
    ///      ~
    /// ```
    ///
    /// `None` for code like `def m; end` or `def m arg; end`
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// def m(a, b = 1, c:, &blk); end
    ///                         ~
    /// ```
    ///
    /// `None` for code like `def m; end` or `def m arg; end`
    pub end_l: Option<Loc>,

}

impl Args {
    // getters

    /// Returns `args` field
    pub fn get_args(&self) -> &Vec<Node> {
        &self.args
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }


    // setters

    /// Sets `args` field
    pub fn set_args(&mut self, args: Vec<Node>) {
        self.args = args;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalArgs {
        let Self { args, expression_l, begin_l, end_l,  } = self;
        super::InternalArgs { args, expression_l, begin_l, end_l,  }
    }
}

impl InnerNode for Args {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "args"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() { node.inner_ref().print_with_locs(); }
        self.get_expression_l().print("expression");
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
    }
}
