// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `a &&= 1` statement.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct AndAsgn {
    /// Receiver of the `&&=` operation.
    ///
    /// `Lvasgn("a")` node for `a &&= 1`
    pub recv: Box<Node>,

    /// Right hand statement of assignment
    ///
    /// `Int("1")` node for `a &&= 1`
    pub value: Box<Node>,

    /// Location of the `&&=` operator
    ///
    /// ```text
    /// a &&= 1
    ///   ~~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// a &&= 1
    /// ~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl AndAsgn {
    // getters

    /// Returns `recv` field
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Box<Node>) {
        self.recv = recv;
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalAndAsgn {
        let Self { recv, value, operator_l, expression_l,  } = self;
        super::InternalAndAsgn { recv, value, operator_l, expression_l,  }
    }
}

impl InnerNode for AndAsgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_recv());
        result.push_node(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "and_asgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().inner_ref().print_with_locs();
        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
