// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `foo && bar` (or `foo and bar`) statement.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct And {
    /// Left hand statament of the `&&` operation.
    ///
    /// `Lvar("foo")` node for `foo && bar`
    pub lhs: Box<Node>,

    /// Right hand statement of the `&&` operation.
    ///
    /// `Lvar("bar")` node for `foo && bar`
    pub rhs: Box<Node>,

    /// Location of the `&&` (or `and`) operator
    ///
    /// ```text
    /// a && b
    ///   ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// a && b
    /// ~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl And {
    // getters

    /// Returns `lhs` field
    pub fn get_lhs(&self) -> &Box<Node> {
        &self.lhs
    }

    /// Returns `rhs` field
    pub fn get_rhs(&self) -> &Box<Node> {
        &self.rhs
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `lhs` field
    pub fn set_lhs(&mut self, lhs: Box<Node>) {
        self.lhs = lhs;
    }

    /// Sets `rhs` field
    pub fn set_rhs(&mut self, rhs: Box<Node>) {
        self.rhs = rhs;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalAnd {
        let Self { lhs, rhs, operator_l, expression_l,  } = self;
        super::InternalAnd { lhs, rhs, operator_l, expression_l,  }
    }
}

impl InnerNode for And {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_lhs());
        result.push_node(self.get_rhs());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "and"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_lhs().inner_ref().print_with_locs();
        self.get_rhs().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
