use crate::codegen::rust::nodes::helpers::filename;
use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

#[cfg(feature = \"compile-with-external-structures\")]
mod external;
#[cfg(feature = \"compile-with-external-structures\")]
pub use external::{{ helper node-camelcase-name }};

#[cfg(not(feature = \"compile-with-external-structures\"))]
mod native;
#[cfg(not(feature = \"compile-with-external-structures\"))]
pub use native::{{ helper node-camelcase-name }};

mod internal;
pub(crate) use internal::Internal{{ helper node-camelcase-name }};

#[cfg(test)]
mod tests;
";

pub(crate) fn codegen(node: &lib_ruby_parser_nodes::Node) {
    let template = NodeTemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(node, &fns);

    let dir = filename(node);
    let path = format!("src/nodes/types/{}/mod.rs", dir);
    std::fs::write(&path, contents).unwrap();
}
