use crate::codegen::rust::nodes::helpers::filename;
use lib_ruby_parser_nodes::{template::*, Node};

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

{{ helper imports }}

#[repr(C)]
pub(crate) struct Internal{{ helper node-camelcase-name }} {
{{ each node-field }}<dnl>
    #[allow(dead_code)]
    pub(crate) {{ helper node-field-rust-field-name }}: {{ helper node-field-rust-field-type }},
{{ end }}<dnl>
}
";

pub(crate) fn codegen(node: &lib_ruby_parser_nodes::Node) {
    let template = NodeTemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = crate::codegen::fns::default_fns!();

    fns.register::<Node, F::Helper>("imports", local_helpers::imports);

    let contents = template.render(node, &fns);

    let dir = filename(node);
    let path = format!("src/nodes/types/{}/internal.rs", dir);
    std::fs::write(&path, contents).unwrap();
}

mod local_helpers {
    use lib_ruby_parser_nodes::{node_has_field, Node};

    pub(crate) fn imports(node: &Node) -> String {
        use lib_ruby_parser_nodes::NodeFieldType::*;

        let mut imports = vec![];
        imports.push("use crate::Loc;");

        if node_has_field!(node, Node | Nodes | MaybeNode { .. }) {
            imports.push("use crate::Node;");
        }

        if node_has_field!(node, StringValue) {
            imports.push("use crate::Bytes;");
        }

        if node_has_field!(node, MaybeNode { .. } | MaybeLoc | MaybeStr { .. }) {
            imports.push("crate::use_native_or_external!(Maybe);");
        }

        if node_has_field!(node, Node | MaybeNode { .. }) {
            imports.push("crate::use_native_or_external!(Ptr);");
        }

        if node_has_field!(node, Nodes) {
            imports.push("crate::use_native_or_external!(List);");
        }

        if node_has_field!(node, Str { .. } | MaybeStr { .. }) {
            imports.push("crate::use_native_or_external!(StringPtr);");
        }

        imports.join("\n")
    }
}
