use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

crate::use_native_or_external!(StringPtr);

use super::DiagnosticMessage;
use super::variants::*;

impl DiagnosticMessage {
{{ each message }}<dnl>
    /// Constructs {{ helper message-camelcase-name }} variant
    pub fn new_{{ helper message-lower-name }}(<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-name }}: {{ helper message-field-rust-field-type }}, <dnl>
{{ end }}) -> Self {
        Self::{{ helper message-camelcase-name }}({{ helper message-camelcase-name }} {<dnl>
{{ each message-field }}{{ helper message-field-name }}, {{ end }}})
    }
{{ end }}<dnl>
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/message/native/constructors.rs", contents).unwrap();
}
