use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

use super::DiagnosticMessage;

impl PartialEq for DiagnosticMessage {
    fn eq(&self, other: &Self) -> bool {
{{ each message }}<dnl>
        if let Some(lhs) = self.as_{{ helper message-lower-name }}() {
            if let Some(rhs) = other.as_{{ helper message-lower-name }}() {
                return lhs == rhs;
            } else {
                return false;
            }
        }
{{ end }}<dnl>
        panic!(\"unrecognized diagnostic message type\")
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/message/external/impl_partial_eq.rs", contents).unwrap();
}
