use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

use super::{DiagnosticMessage};

impl Clone for DiagnosticMessage {
    fn clone(&self) -> Self {
{{ each message }}<dnl>
{{ if message-has-no-fields }}<dnl>
        if self.is_{{ helper message-lower-name }}() {
            return Self::new_{{ helper message-lower-name }}();
        }
{{ else }}<dnl>
        if let Some(variant) = self.as_{{ helper message-lower-name }}() {
            return Self::new_{{ helper message-lower-name }}(<dnl>
{{ each message-field }}<dnl>
variant.get_{{ helper message-field-name }}().clone(), <dnl>
{{ end }}<dnl>
);
        }
{{ end }}<dnl>
{{ end }}<dnl>
        panic!(\"unrecognized diagnostic message type\")
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/message/external/impl_clone.rs", contents).unwrap();
}
