use lib_ruby_parser_nodes::{template::*, Message};

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

use crate::containers::ExternalStringPtr as StringPtr;
use crate::blobs::{Blob, HasBlob};
use super::DiagnosticMessage;

extern \"C\" {
{{ each message }}<dnl>
    fn {{ helper extern-ctor-name }}(<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-name }}: {{ helper message-field-rust-blob-type }},<dnl>
{{ end }}<dnl>
) -> Blob<DiagnosticMessage>;
{{ end }}<dnl>
}

impl DiagnosticMessage {
{{ each message }}<dnl>
    /// Constructs {{ helper message-camelcase-name }} variant
    pub fn new_{{ helper message-lower-name }}(<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-name }}: {{ helper message-field-rust-field-type }},<dnl>
{{ end }}<dnl>
) -> Self {
        let blob = unsafe { {{ helper extern-ctor-name }}(<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-name }}.into_blob(), <dnl>
{{ end }}<dnl>
) };
        Self { blob }
    }
{{ end }}<dnl>
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = crate::codegen::fns::default_fns!();

    fns.register::<Message, F::Helper>(
        "extern-ctor-name",
        lib_ruby_parser_bindings::helpers::messages::constructor::name,
    );

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/message/external/constructors.rs", contents).unwrap();
}
