use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "#ifndef LIB_RUBY_PARSER_SIZES_GEN_HPP
#define LIB_RUBY_PARSER_SIZES_GEN_HPP

// This file is autogenerated by {{ helper generated-by }}

#include <iostream>
#include \"structs.hpp\"

using namespace lib_ruby_parser;

void print_node_sizes()
{
{{ each node }}<dnl>
    std::cout << \"LIB_RUBY_PARSER_NODE_{{ helper node-upper-name }}_SIZE=\" << sizeof({{ helper node-camelcase-name }}) << \"\\n\";
{{ end }}<dnl>
}

void print_messages_sizes()
{
{{ each message }}<dnl>
    std::cout << \"LIB_RUBY_PARSER_MESSAGE_{{ helper message-upper-name }}_SIZE=\" << sizeof({{ helper message-camelcase-name }}) << \"\\n\";
{{ end }}<dnl>
}

#endif // LIB_RUBY_PARSER_SIZES_GEN_HPP
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/sizes_gen.hpp", contents).unwrap();
}
