use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "#ifndef LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_HPP
#define LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_HPP

// This file is autogenerated by {{ helper generated-by }}

#include \"structs.hpp\"
#include \"declare_blob.hpp\"

// Node blobs
{{ each node }}<dnl>
DECLARE_BLOB_FOR({{ helper node-camelcase-name }});
#define UNPACK_{{ helper node-camelcase-name }}(blob) (({{ helper node-camelcase-name }}_BLOB_UNION){.as_blob = blob}).as_value
#define PACK_{{ helper node-camelcase-name }}(value) (({{ helper node-camelcase-name }}_BLOB_UNION){.as_value = value}).as_blob

{{ end }}<dnl>
// Message blobs
{{ each message }}<dnl>
DECLARE_BLOB_FOR({{ helper message-camelcase-name }});
#define UNPACK_{{ helper message-camelcase-name }}(blob) (({{ helper message-camelcase-name }}_BLOB_UNION){.as_blob = blob}).as_value
#define PACK_{{ helper message-camelcase-name }}(value) (({{ helper message-camelcase-name }}_BLOB_UNION){.as_value = value}).as_blob

{{ end }}<dnl>
#endif // LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_HPP
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/blobs_gen.hpp", contents).unwrap();
}
