use lib_ruby_parser_nodes::{template::*, Message, MessageField};

const TEMPLATE: &str = "// This file is autogenerated by {{ helper generated-by }}

#include \"bindings.hpp\"

extern \"C\"
{
    // constructors
{{ each message }}<dnl>
    {{ helper constructor-sig }}
    {
        return PACK_DiagnosticMessage(DiagnosticMessage({{ helper message-camelcase-name }} {
{{ each message-field }}<dnl>
            UNPACK_{{ helper message-field-cpp-field-type }}({{ helper message-field-c-name }}_blob),
{{ end }}<dnl>
        }));
    }
{{ end }}<dnl>

    // variant getters
{{ each message }}<dnl>
    {{ helper variant-getter-sig }}
    {
        const DiagnosticMessage *self = (const DiagnosticMessage *)self_blob;
        const {{ helper message-camelcase-name }} *variant = std::get_if<{{ helper message-camelcase-name }}>(&(self->variant));
        return (const {{ helper message-camelcase-name }}_BLOB*)variant;
    }
{{ end }}<dnl>

    // field getters
{{ each message }}<dnl>
{{ each message-field }}<dnl>
    {{ helper field-getter-sig }}
    {
        const {{ helper message-camelcase-name }} *self = (const {{ helper message-camelcase-name }} *)self_blob;
        return (const {{ helper message-field-cpp-blob-type }} *)(&(self->{{ helper message-field-c-name }}));
    }
{{ end }}<dnl>
{{ end }}<dnl>

    // variant predicates
{{ each message }}<dnl>
    {{ helper variant-predicate-sig }}
    {
        const DiagnosticMessage *self = (const DiagnosticMessage *)self_blob;
        return std::holds_alternative<{{ helper message-camelcase-name }}>(self->variant);
    }
{{ end }}<dnl>

    void lib_ruby_parser__external__diagnostic_message__drop(DiagnosticMessage_BLOB *self_blob)
    {
        DiagnosticMessage *self = (DiagnosticMessage *)self_blob;
        drop_diagnostic_message(self);
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = crate::codegen::fns::default_fns!();

    fns.register::<Message, F::Helper>(
        "constructor-sig",
        lib_ruby_parser_bindings::helpers::messages::constructor::sig,
    );
    fns.register::<Message, F::Helper>(
        "variant-getter-sig",
        lib_ruby_parser_bindings::helpers::messages::variant_getter::sig,
    );
    fns.register::<MessageField, F::Helper>(
        "field-getter-sig",
        lib_ruby_parser_bindings::helpers::messages::field_getter::sig,
    );
    fns.register::<Message, F::Helper>(
        "variant-predicate-sig",
        lib_ruby_parser_bindings::helpers::messages::variant_predicate::sig,
    );

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/bindings_messages.cpp", contents).unwrap();
}
