// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalList as List;

use super::internal::InternalYield;
use crate::blobs::{HasBlob, Blob};

/// Represents an `yield` keyword
#[repr(C)]
pub struct Yield {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Yield {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Yield")
            .field("args", &self.get_args())
            .field("keyword_l", &self.get_keyword_l())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Yield {
    fn eq(&self, other: &Self) -> bool {
        if self.get_args() != other.get_args() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Yield {
    // getters
    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__yield__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__yield__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__yield__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__yield__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__yield__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__yield__set_args(&mut self.blob, args.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__yield__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__yield__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__yield__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__yield__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalYield {
        unsafe { lib_ruby_parser__external__nodes__yield__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__yield__get_args(blob: *const Blob<Yield>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__yield__set_args(blob: *mut Blob<Yield>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__yield__get_keyword_l(blob: *const Blob<Yield>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__yield__set_keyword_l(blob: *mut Blob<Yield>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__yield__get_begin_l(blob: *const Blob<Yield>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__yield__set_begin_l(blob: *mut Blob<Yield>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__yield__get_end_l(blob: *const Blob<Yield>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__yield__set_end_l(blob: *mut Blob<Yield>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__yield__get_expression_l(blob: *const Blob<Yield>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__yield__set_expression_l(blob: *mut Blob<Yield>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__yield__into_internal(blob: Blob<Yield>) -> InternalYield;
    fn lib_ruby_parser__external__nodes__yield__drop(blob: *mut Blob<Yield>);
}

impl InnerNode for Yield {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "yield"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() { node.inner_ref().print_with_locs(); }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Yield {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__yield__drop(&mut self.blob) }
    }
}
