// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a executable here-document literal (both with and without interpolation)
///
/// It's similar to `Xstr` in terms of abstract syntax tree, but has different source maps.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct XHeredoc {
    /// A list of string parts (static literals and interpolated expressions)
    pub parts: Vec<Node>,

    /// Location of the executable here-document body
    ///
    /// ```text
    /// <<-`HERE`\n  a\n   #{42}\nHERE
    ///          ~~~~~~~~~~~~~~~
    /// ```
    pub heredoc_body_l: Loc,

    /// Location of the executable here-document end
    ///
    /// ```text
    /// <<-`HERE`\n  a\n   #{42}\nHERE
    ///                           ~~~~
    /// ```
    pub heredoc_end_l: Loc,

    /// Location of the executable here-document identifier
    ///
    /// ```text
    /// <<-`HERE`\n  a\n   #{42}\nHERE
    /// ~~~~~~~
    /// ```
    ///
    /// **Note**: This is the only node (with `Heredoc`) that has `expression_l` smaller that all other sub-locations merged.
    /// The reason for that is that it's possible to add more code after here-document ID:
    ///
    /// ```text
    /// <<-`HERE` + "rest"
    /// content
    /// HERE
    /// ```
    pub expression_l: Loc,

}

impl XHeredoc {
    // getters

    /// Returns `parts` field
    pub fn get_parts(&self) -> &Vec<Node> {
        &self.parts
    }

    /// Returns `heredoc_body_l` field
    pub fn get_heredoc_body_l(&self) -> &Loc {
        &self.heredoc_body_l
    }

    /// Returns `heredoc_end_l` field
    pub fn get_heredoc_end_l(&self) -> &Loc {
        &self.heredoc_end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `parts` field
    pub fn set_parts(&mut self, parts: Vec<Node>) {
        self.parts = parts;
    }

    /// Sets `heredoc_body_l` field
    pub fn set_heredoc_body_l(&mut self, heredoc_body_l: Loc) {
        self.heredoc_body_l = heredoc_body_l;
    }

    /// Sets `heredoc_end_l` field
    pub fn set_heredoc_end_l(&mut self, heredoc_end_l: Loc) {
        self.heredoc_end_l = heredoc_end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalXHeredoc {
        let Self { parts, heredoc_body_l, heredoc_end_l, expression_l,  } = self;
        super::InternalXHeredoc { parts, heredoc_body_l, heredoc_end_l, expression_l,  }
    }
}

impl InnerNode for XHeredoc {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_parts());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "xstr"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_parts().iter() { node.inner_ref().print_with_locs(); }
        self.get_heredoc_body_l().print("heredoc_body");
        self.get_heredoc_end_l().print("heredoc_end");
        self.get_expression_l().print("expression");
    }
}
