// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a branch of the `case` statement (i.e. `when foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct When {
    /// A list of values to compare/match against
    pub patterns: Vec<Node>,

    /// Body of the `when` branch
    pub body: Option<Box<Node>>,

    /// Location of the `when` keyword
    ///
    /// ```text
    /// case foo; when bar; end
    ///           ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// case foo; when bar then baz; end
    ///                    ~~~~
    /// ```
    ///
    /// `then` is optional, and so `begin_l` can be `None`
    pub begin_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; when bar then baz; end
    ///           ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl When {
    // getters

    /// Returns `patterns` field
    pub fn get_patterns(&self) -> &Vec<Node> {
        &self.patterns
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `patterns` field
    pub fn set_patterns(&mut self, patterns: Vec<Node>) {
        self.patterns = patterns;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalWhen {
        let Self { patterns, body, keyword_l, begin_l, expression_l,  } = self;
        super::InternalWhen { patterns, body, keyword_l, begin_l, expression_l,  }
    }
}

impl InnerNode for When {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_patterns());
        result.push_maybe_node_or_nil(self.get_body());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "when"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_patterns().iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        self.get_expression_l().print("expression");
    }
}
