// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `unless` guard used in pattern matching (i.e. `in pattern unless guard`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct UnlessGuard {
    /// Condition of the guard, `Lvar("foo")` in `in pattern unless guard`
    pub cond: Box<Node>,

    /// Location of the `unless` keyword
    ///
    /// ```text
    /// case foo; in pattern unless cond; end
    ///                      ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in pattern unless cond; end
    ///                      ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl UnlessGuard {
    // getters

    /// Returns `cond` field
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Box<Node>) {
        self.cond = cond;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalUnlessGuard {
        let Self { cond, keyword_l, expression_l,  } = self;
        super::InternalUnlessGuard { cond, keyword_l, expression_l,  }
    }
}

impl InnerNode for UnlessGuard {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "unless_guard"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
