// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `undef` keyword (e.g. `undef foo, :bar`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Undef {
    /// A list of names to `undef`
    pub names: Vec<Node>,

    /// Location the `undef` keyword
    ///
    /// ```text
    /// undef foo, :bar
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// undef :foo, bar
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Undef {
    // getters

    /// Returns `names` field
    pub fn get_names(&self) -> &Vec<Node> {
        &self.names
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `names` field
    pub fn set_names(&mut self, names: Vec<Node>) {
        self.names = names;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalUndef {
        let Self { names, keyword_l, expression_l,  } = self;
        super::InternalUndef { names, keyword_l, expression_l,  }
    }
}

impl InnerNode for Undef {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_names());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "undef"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_names().iter() { node.inner_ref().print_with_locs(); }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
