// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Bytes;
use crate::containers::ExternalMaybe as Maybe;

use super::internal::InternalStr;
use crate::blobs::{HasBlob, Blob};

/// Represents a plain non-interpolated string literal (e.g. `"foo"`)
#[repr(C)]
pub struct Str {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Str {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Str")
            .field("value", &self.get_value())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Str {
    fn eq(&self, other: &Self) -> bool {
        if self.get_value() != other.get_value() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Str {
    // getters
    /// Returns `value` field
    pub fn get_value(&self) -> &Bytes {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__str__get_value(&self.blob) as *const Bytes)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__str__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__str__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__str__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `value` field
    pub fn set_value(&mut self, value: Bytes) {
        unsafe { lib_ruby_parser__external__nodes__str__set_value(&mut self.blob, value.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__str__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__str__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__str__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalStr {
        unsafe { lib_ruby_parser__external__nodes__str__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__str__get_value(blob: *const Blob<Str>) -> *mut Blob<Bytes>;
    fn lib_ruby_parser__external__nodes__str__set_value(blob: *mut Blob<Str>, blob: Blob<Bytes>);
    fn lib_ruby_parser__external__nodes__str__get_begin_l(blob: *const Blob<Str>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__str__set_begin_l(blob: *mut Blob<Str>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__str__get_end_l(blob: *const Blob<Str>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__str__set_end_l(blob: *mut Blob<Str>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__str__get_expression_l(blob: *const Blob<Str>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__str__set_expression_l(blob: *mut Blob<Str>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__str__into_internal(blob: Blob<Str>) -> InternalStr;
    fn lib_ruby_parser__external__nodes__str__drop(blob: *mut Blob<Str>);
}

impl InnerNode for Str {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_string_value(self.get_value());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "str"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Str {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__str__drop(&mut self.blob) }
    }
}
