// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an arguments splat (i.e. `*bar` in a call like `foo(*bar)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Splat {
    /// Value that is converted to array
    pub value: Option<Box<Node>>,

    /// Location of the `*` operator
    ///
    /// ```text
    /// foo(*bar)
    ///     ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo(*bar)
    ///     ~~~~
    /// ```
    pub expression_l: Loc,

}

impl Splat {
    // getters

    /// Returns `value` field
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `value` field
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalSplat {
        let Self { value, operator_l, expression_l,  } = self;
        super::InternalSplat { value, operator_l, expression_l,  }
    }
}

impl InnerNode for Splat {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "splat"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_value().as_ref() { node.inner_ref().print_with_locs() }
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
