// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a method call (e.g. `foo.bar(42)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Send {
    /// Receiver of the method call
    ///
    /// `None` for implicit method call (e.g. `foo(42)`)
    pub recv: Option<Box<Node>>,

    /// Name of the method that is called
    pub method_name: String,

    /// A list of arguments
    pub args: Vec<Node>,

    /// Location of the `.` operator
    ///
    /// ```text
    /// foo.bar(42)
    ///    ~
    /// ```
    ///
    /// `None` for implicit method call (e.g. `foo(42)`)
    pub dot_l: Option<Loc>,

    /// Location of the method name
    ///
    /// ```text
    /// foo.bar(42)
    ///     ~~~
    /// ```
    ///
    /// `None` in a very special case when method call is implicit (i.e. `foo.(42)`)
    pub selector_l: Option<Loc>,

    /// Location of open parenthesis
    ///
    /// ```text
    /// foo(42)
    ///    ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of closing parenthesis
    ///
    /// ```text
    /// foo(42)
    ///       ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the operator if method is a setter
    ///
    /// ```text
    /// foo.bar = 42
    ///         ~
    /// ```
    ///
    /// `None` otherwise
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo.bar(42)
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Send {
    // getters

    /// Returns `recv` field
    pub fn get_recv(&self) -> &Option<Box<Node>> {
        &self.recv
    }

    /// Returns `method_name` field
    pub fn get_method_name(&self) -> &String {
        &self.method_name
    }

    /// Returns `args` field
    pub fn get_args(&self) -> &Vec<Node> {
        &self.args
    }

    /// Returns `dot_l` field
    pub fn get_dot_l(&self) -> &Option<Loc> {
        &self.dot_l
    }

    /// Returns `selector_l` field
    pub fn get_selector_l(&self) -> &Option<Loc> {
        &self.selector_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Option<Box<Node>>) {
        self.recv = recv;
    }

    /// Sets `method_name` field
    pub fn set_method_name(&mut self, method_name: String) {
        self.method_name = method_name;
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: Vec<Node>) {
        self.args = args;
    }

    /// Sets `dot_l` field
    pub fn set_dot_l(&mut self, dot_l: Option<Loc>) {
        self.dot_l = dot_l;
    }

    /// Sets `selector_l` field
    pub fn set_selector_l(&mut self, selector_l: Option<Loc>) {
        self.selector_l = selector_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Option<Loc>) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalSend {
        let Self { recv, method_name, args, dot_l, selector_l, begin_l, end_l, operator_l, expression_l,  } = self;
        super::InternalSend { recv, method_name, args, dot_l, selector_l, begin_l, end_l, operator_l, expression_l,  }
    }
}

impl InnerNode for Send {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_recv());
        result.push_str(self.get_method_name());
        result.push_nodes(self.get_args());






        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "send"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_recv().as_ref() { node.inner_ref().print_with_locs() }

        for node in self.get_args().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_dot_l().as_ref() { loc.print("dot") }
        if let Some(loc) = self.get_selector_l().as_ref() { loc.print("selector") }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}
