// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalSend;
use crate::blobs::{HasBlob, Blob};

/// Represents a method call (e.g. `foo.bar(42)`)
#[repr(C)]
pub struct Send {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Send {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Send")
            .field("recv", &self.get_recv())
            .field("method_name", &self.get_method_name())
            .field("args", &self.get_args())
            .field("dot_l", &self.get_dot_l())
            .field("selector_l", &self.get_selector_l())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Send {
    fn eq(&self, other: &Self) -> bool {
        if self.get_recv() != other.get_recv() {
            return false
        }
        if self.get_method_name() != other.get_method_name() {
            return false
        }
        if self.get_args() != other.get_args() {
            return false
        }
        if self.get_dot_l() != other.get_dot_l() {
            return false
        }
        if self.get_selector_l() != other.get_selector_l() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Send {
    // getters
    /// Returns `recv` field
    pub fn get_recv(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_recv(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `method_name` field
    pub fn get_method_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_method_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `dot_l` field
    pub fn get_dot_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_dot_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `selector_l` field
    pub fn get_selector_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_selector_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_operator_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_recv(&mut self.blob, recv.into_blob()) }
    }
    /// Sets `method_name` field
    pub fn set_method_name(&mut self, method_name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__send__set_method_name(&mut self.blob, method_name.into_blob()) }
    }
    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_args(&mut self.blob, args.into_blob()) }
    }
    /// Sets `dot_l` field
    pub fn set_dot_l(&mut self, dot_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_dot_l(&mut self.blob, dot_l.into_blob()) }
    }
    /// Sets `selector_l` field
    pub fn set_selector_l(&mut self, selector_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_selector_l(&mut self.blob, selector_l.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalSend {
        unsafe { lib_ruby_parser__external__nodes__send__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__send__get_recv(blob: *const Blob<Send>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__send__set_recv(blob: *mut Blob<Send>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__send__get_method_name(blob: *const Blob<Send>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__send__set_method_name(blob: *mut Blob<Send>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__send__get_args(blob: *const Blob<Send>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__send__set_args(blob: *mut Blob<Send>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__send__get_dot_l(blob: *const Blob<Send>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__send__set_dot_l(blob: *mut Blob<Send>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__send__get_selector_l(blob: *const Blob<Send>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__send__set_selector_l(blob: *mut Blob<Send>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__send__get_begin_l(blob: *const Blob<Send>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__send__set_begin_l(blob: *mut Blob<Send>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__send__get_end_l(blob: *const Blob<Send>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__send__set_end_l(blob: *mut Blob<Send>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__send__get_operator_l(blob: *const Blob<Send>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__send__set_operator_l(blob: *mut Blob<Send>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__send__get_expression_l(blob: *const Blob<Send>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__send__set_expression_l(blob: *mut Blob<Send>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__send__into_internal(blob: Blob<Send>) -> InternalSend;
    fn lib_ruby_parser__external__nodes__send__drop(blob: *mut Blob<Send>);
}

impl InnerNode for Send {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_recv());
        result.push_str(self.get_method_name());
        result.push_nodes(self.get_args());






        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "send"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_recv().as_ref() { node.inner_ref().print_with_locs() }

        for node in self.get_args().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_dot_l().as_ref() { loc.print("dot") }
        if let Some(loc) = self.get_selector_l().as_ref() { loc.print("selector") }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Send {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__send__drop(&mut self.blob) }
    }
}
