// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalSClass;
use crate::blobs::{HasBlob, Blob};

/// Represents opening a singleton class (i.e. `class << foo; ... end;`)
#[repr(C)]
pub struct SClass {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for SClass {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("SClass")
            .field("expr", &self.get_expr())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("operator_l", &self.get_operator_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for SClass {
    fn eq(&self, other: &Self) -> bool {
        if self.get_expr() != other.get_expr() {
            return false
        }
        if self.get_body() != other.get_body() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl SClass {
    // getters
    /// Returns `expr` field
    pub fn get_expr(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__s_class__get_expr(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `body` field
    pub fn get_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__s_class__get_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__s_class__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__s_class__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__s_class__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__s_class__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `expr` field
    pub fn set_expr(&mut self, expr: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__s_class__set_expr(&mut self.blob, expr.into_blob()) }
    }
    /// Sets `body` field
    pub fn set_body(&mut self, body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__s_class__set_body(&mut self.blob, body.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__s_class__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__s_class__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__s_class__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__s_class__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalSClass {
        unsafe { lib_ruby_parser__external__nodes__s_class__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__s_class__get_expr(blob: *const Blob<SClass>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__s_class__set_expr(blob: *mut Blob<SClass>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__s_class__get_body(blob: *const Blob<SClass>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__s_class__set_body(blob: *mut Blob<SClass>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__s_class__get_keyword_l(blob: *const Blob<SClass>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__s_class__set_keyword_l(blob: *mut Blob<SClass>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__s_class__get_operator_l(blob: *const Blob<SClass>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__s_class__set_operator_l(blob: *mut Blob<SClass>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__s_class__get_end_l(blob: *const Blob<SClass>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__s_class__set_end_l(blob: *mut Blob<SClass>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__s_class__get_expression_l(blob: *const Blob<SClass>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__s_class__set_expression_l(blob: *mut Blob<SClass>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__s_class__into_internal(blob: Blob<SClass>) -> InternalSClass;
    fn lib_ruby_parser__external__nodes__s_class__drop(blob: *mut Blob<SClass>);
}

impl InnerNode for SClass {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_expr());
        result.push_maybe_node_or_nil(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "sclass"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expr().inner_ref().print_with_locs();
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_operator_l().print("operator");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for SClass {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__s_class__drop(&mut self.blob) }
    }
}
