// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a single `rescue` handler (i.e. `rescue E => e ...`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct RescueBody {
    /// A list of exception classes
    ///
    /// `None` if no classes specified (i.e. `rescue => e; ...` or just `rescue; ...`)
    pub exc_list: Option<Box<Node>>,

    /// Variable that captures exception
    ///
    /// `None` if no variable specified (i.e. `rescue E; ...` or just `rescue; ... `)
    pub exc_var: Option<Box<Node>>,

    /// Body of the handler
    pub body: Option<Box<Node>>,

    /// Location of the `rescue` keyword
    ///
    /// ```text
    /// begin; 1; rescue E => e; 2; end
    ///           ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// begin; 1; rescue E => e; 2; end
    ///                    ~~
    /// ```
    ///
    /// `None` if exception is not captured.
    pub assoc_l: Option<Loc>,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// begin; 1; rescue E => e then; 2; end
    ///                         ~~~~
    /// ```
    ///
    /// `then` is optional, so `begin_l` can be `None`
    pub begin_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue E => e then; 2; end
    ///           ~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl RescueBody {
    // getters

    /// Returns `exc_list` field
    pub fn get_exc_list(&self) -> &Option<Box<Node>> {
        &self.exc_list
    }

    /// Returns `exc_var` field
    pub fn get_exc_var(&self) -> &Option<Box<Node>> {
        &self.exc_var
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `assoc_l` field
    pub fn get_assoc_l(&self) -> &Option<Loc> {
        &self.assoc_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `exc_list` field
    pub fn set_exc_list(&mut self, exc_list: Option<Box<Node>>) {
        self.exc_list = exc_list;
    }

    /// Sets `exc_var` field
    pub fn set_exc_var(&mut self, exc_var: Option<Box<Node>>) {
        self.exc_var = exc_var;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `assoc_l` field
    pub fn set_assoc_l(&mut self, assoc_l: Option<Loc>) {
        self.assoc_l = assoc_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRescueBody {
        let Self { exc_list, exc_var, body, keyword_l, assoc_l, begin_l, expression_l,  } = self;
        super::InternalRescueBody { exc_list, exc_var, body, keyword_l, assoc_l, begin_l, expression_l,  }
    }
}

impl InnerNode for RescueBody {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_exc_list());
        result.push_maybe_node_or_nil(self.get_exc_var());
        result.push_maybe_node_or_nil(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "resbody"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_exc_list().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_exc_var().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_assoc_l().as_ref() { loc.print("assoc") }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        self.get_expression_l().print("expression");
    }
}
