// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalRescueBody;
use crate::blobs::{HasBlob, Blob};

/// Represents a single `rescue` handler (i.e. `rescue E => e ...`)
#[repr(C)]
pub struct RescueBody {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for RescueBody {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("RescueBody")
            .field("exc_list", &self.get_exc_list())
            .field("exc_var", &self.get_exc_var())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("assoc_l", &self.get_assoc_l())
            .field("begin_l", &self.get_begin_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for RescueBody {
    fn eq(&self, other: &Self) -> bool {
        if self.get_exc_list() != other.get_exc_list() {
            return false
        }
        if self.get_exc_var() != other.get_exc_var() {
            return false
        }
        if self.get_body() != other.get_body() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_assoc_l() != other.get_assoc_l() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl RescueBody {
    // getters
    /// Returns `exc_list` field
    pub fn get_exc_list(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_exc_list(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `exc_var` field
    pub fn get_exc_var(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_exc_var(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `body` field
    pub fn get_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `assoc_l` field
    pub fn get_assoc_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_assoc_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue_body__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `exc_list` field
    pub fn set_exc_list(&mut self, exc_list: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_exc_list(&mut self.blob, exc_list.into_blob()) }
    }
    /// Sets `exc_var` field
    pub fn set_exc_var(&mut self, exc_var: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_exc_var(&mut self.blob, exc_var.into_blob()) }
    }
    /// Sets `body` field
    pub fn set_body(&mut self, body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_body(&mut self.blob, body.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `assoc_l` field
    pub fn set_assoc_l(&mut self, assoc_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_assoc_l(&mut self.blob, assoc_l.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalRescueBody {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__rescue_body__get_exc_list(blob: *const Blob<RescueBody>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_exc_list(blob: *mut Blob<RescueBody>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__rescue_body__get_exc_var(blob: *const Blob<RescueBody>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_exc_var(blob: *mut Blob<RescueBody>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__rescue_body__get_body(blob: *const Blob<RescueBody>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_body(blob: *mut Blob<RescueBody>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__rescue_body__get_keyword_l(blob: *const Blob<RescueBody>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_keyword_l(blob: *mut Blob<RescueBody>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__rescue_body__get_assoc_l(blob: *const Blob<RescueBody>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_assoc_l(blob: *mut Blob<RescueBody>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__rescue_body__get_begin_l(blob: *const Blob<RescueBody>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_begin_l(blob: *mut Blob<RescueBody>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__rescue_body__get_expression_l(blob: *const Blob<RescueBody>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__rescue_body__set_expression_l(blob: *mut Blob<RescueBody>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__rescue_body__into_internal(blob: Blob<RescueBody>) -> InternalRescueBody;
    fn lib_ruby_parser__external__nodes__rescue_body__drop(blob: *mut Blob<RescueBody>);
}

impl InnerNode for RescueBody {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_exc_list());
        result.push_maybe_node_or_nil(self.get_exc_var());
        result.push_maybe_node_or_nil(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "resbody"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_exc_list().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_exc_var().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_assoc_l().as_ref() { loc.print("assoc") }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for RescueBody {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__rescue_body__drop(&mut self.blob) }
    }
}
