// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `rescue` block
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Rescue {
    /// Body of the block that is wrapped into `rescue` (i.e. the part that may throw an error)
    pub body: Option<Box<Node>>,

    /// A list of `rescue` handlers (see `RescueBody` node)
    pub rescue_bodies: Vec<Node>,

    /// Else branch.
    ///
    /// `None` if there's no `else` branch
    pub else_: Option<Box<Node>>,

    /// Location of the `else` keyword
    ///
    /// ```text
    /// begin; 1; rescue StandardError => e; 2; else; 3; end
    ///                                         ~~~~
    /// ```
    ///
    /// `None` if there's no `else` branch
    pub else_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue StandardError => e; 2; else; 3; end
    ///        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    ///
    /// **Note**: `begin/end` keywords belong to `KwBegin` node
    pub expression_l: Loc,

}

impl Rescue {
    // getters

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `rescue_bodies` field
    pub fn get_rescue_bodies(&self) -> &Vec<Node> {
        &self.rescue_bodies
    }

    /// Returns `else_` field
    pub fn get_else(&self) -> &Option<Box<Node>> {
        &self.else_
    }

    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &Option<Loc> {
        &self.else_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `rescue_bodies` field
    pub fn set_rescue_bodies(&mut self, rescue_bodies: Vec<Node>) {
        self.rescue_bodies = rescue_bodies;
    }

    /// Sets `else_` field
    pub fn set_else(&mut self, else_: Option<Box<Node>>) {
        self.else_ = else_;
    }

    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: Option<Loc>) {
        self.else_l = else_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRescue {
        let Self { body, rescue_bodies, else_, else_l, expression_l,  } = self;
        super::InternalRescue { body, rescue_bodies, else_, else_l, expression_l,  }
    }
}

impl InnerNode for Rescue {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_body());
        result.push_nodes(self.get_rescue_bodies());
        result.push_maybe_node_or_nil(self.get_else());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "rescue"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        for node in self.get_rescue_bodies().iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.get_else().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(loc) = self.get_else_l().as_ref() { loc.print("else") }
        self.get_expression_l().print("expression");
    }
}
