// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents regex literal (e.g. `/foo/`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Regexp {
    /// A list of static and dynamic regex parts
    pub parts: Vec<Node>,

    /// Regex options.
    ///
    /// `None` if regex has no explicit flags
    pub options: Option<Box<Node>>,

    /// Location of the regex begin
    ///
    /// ```text
    /// /foo/
    /// ~
    ///
    /// %r{foo}
    /// ~~
    /// ```
    pub begin_l: Loc,

    /// Location of the regex end
    ///
    /// ```text
    /// /foo/
    ///     ~
    ///
    /// %r{foo}
    ///       ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// /foo/mix
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Regexp {
    // getters

    /// Returns `parts` field
    pub fn get_parts(&self) -> &Vec<Node> {
        &self.parts
    }

    /// Returns `options` field
    pub fn get_options(&self) -> &Option<Box<Node>> {
        &self.options
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `parts` field
    pub fn set_parts(&mut self, parts: Vec<Node>) {
        self.parts = parts;
    }

    /// Sets `options` field
    pub fn set_options(&mut self, options: Option<Box<Node>>) {
        self.options = options;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRegexp {
        let Self { parts, options, begin_l, end_l, expression_l,  } = self;
        super::InternalRegexp { parts, options, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Regexp {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_parts());
        result.push_regex_options(self.get_options());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "regexp"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_parts().iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.get_options().as_ref() { node.inner_ref().print_with_locs() }
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
