// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a pattern based on a "pinned" variable (e.g. `^foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Pin {
    /// Variable that is pinned
    pub var: Box<Node>,

    /// Location of the `^` operator
    ///
    /// ```text
    /// case foo; in ^bar; end
    ///              ~
    /// ```
    pub selector_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in ^bar; end
    ///              ~~~~
    /// ```
    pub expression_l: Loc,

}

impl Pin {
    // getters

    /// Returns `var` field
    pub fn get_var(&self) -> &Box<Node> {
        &self.var
    }

    /// Returns `selector_l` field
    pub fn get_selector_l(&self) -> &Loc {
        &self.selector_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `var` field
    pub fn set_var(&mut self, var: Box<Node>) {
        self.var = var;
    }

    /// Sets `selector_l` field
    pub fn set_selector_l(&mut self, selector_l: Loc) {
        self.selector_l = selector_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalPin {
        let Self { var, selector_l, expression_l,  } = self;
        super::InternalPin { var, selector_l, expression_l,  }
    }
}

impl InnerNode for Pin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_var());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_var().inner_ref().print_with_locs();
        self.get_selector_l().print("selector");
        self.get_expression_l().print("expression");
    }
}
