// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a key/value pair (e.g. a part of the `Hash` node)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Pair {
    /// Key of the pair
    pub key: Box<Node>,

    /// Value of the pair
    pub value: Box<Node>,

    /// Location of the `:` or `=>` operator
    ///
    /// ```text
    /// { foo: bar }
    ///      ~
    ///
    /// { :foo => bar }
    ///        ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// { foo: bar }
    ///   ~~~~~~~~
    ///
    /// { :foo => bar }
    ///   ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Pair {
    // getters

    /// Returns `key` field
    pub fn get_key(&self) -> &Box<Node> {
        &self.key
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `key` field
    pub fn set_key(&mut self, key: Box<Node>) {
        self.key = key;
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalPair {
        let Self { key, value, operator_l, expression_l,  } = self;
        super::InternalPair { key, value, operator_l, expression_l,  }
    }
}

impl InnerNode for Pair {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_key());
        result.push_node(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pair"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_key().inner_ref().print_with_locs();
        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
