// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalOptarg;
use crate::blobs::{HasBlob, Blob};

/// Represents optional positional argument (i.e. `foo` in `m(foo = 1)`)
#[repr(C)]
pub struct Optarg {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Optarg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Optarg")
            .field("name", &self.get_name())
            .field("default", &self.get_default())
            .field("name_l", &self.get_name_l())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Optarg {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_default() != other.get_default() {
            return false
        }
        if self.get_name_l() != other.get_name_l() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Optarg {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__optarg__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `default` field
    pub fn get_default(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__optarg__get_default(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__optarg__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__optarg__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__optarg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__optarg__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `default` field
    pub fn set_default(&mut self, default: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__optarg__set_default(&mut self.blob, default.into_blob()) }
    }
    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__optarg__set_name_l(&mut self.blob, name_l.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__optarg__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__optarg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalOptarg {
        unsafe { lib_ruby_parser__external__nodes__optarg__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__optarg__get_name(blob: *const Blob<Optarg>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__optarg__set_name(blob: *mut Blob<Optarg>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__optarg__get_default(blob: *const Blob<Optarg>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__optarg__set_default(blob: *mut Blob<Optarg>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__optarg__get_name_l(blob: *const Blob<Optarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__optarg__set_name_l(blob: *mut Blob<Optarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__optarg__get_operator_l(blob: *const Blob<Optarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__optarg__set_operator_l(blob: *mut Blob<Optarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__optarg__get_expression_l(blob: *const Blob<Optarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__optarg__set_expression_l(blob: *mut Blob<Optarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__optarg__into_internal(blob: Blob<Optarg>) -> InternalOptarg;
    fn lib_ruby_parser__external__nodes__optarg__drop(blob: *mut Blob<Optarg>);
}

impl InnerNode for Optarg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_node(self.get_default());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "optarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_default().inner_ref().print_with_locs();
        self.get_name_l().print("name");
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Optarg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__optarg__drop(&mut self.blob) }
    }
}
