// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an operation with assignment (e.g. `a += 1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct OpAsgn {
    /// Left hand statement of the assignment
    pub recv: Box<Node>,

    /// Operator, can be one of:
    /// 1. `+=`
    /// 2. `-=`
    /// 3. `*=`
    /// 4. `/=`
    /// 5. `|=`
    /// 6. `&=`
    /// 7. `>>=`
    /// 8. `<<=`
    /// 9. `%=`
    /// 10. `^=`
    /// 11. `**=`
    pub operator: String,

    /// Right hand statement of the assignment
    pub value: Box<Node>,

    /// Location of the operator
    ///
    /// ```text
    /// a.b <<= c
    ///     ~~~
    /// ```
    pub operator_l: Loc,

    /// Location of the operator
    ///
    /// ```text
    /// a.b <<= c
    /// ~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl OpAsgn {
    // getters

    /// Returns `recv` field
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    /// Returns `operator` field
    pub fn get_operator(&self) -> &String {
        &self.operator
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Box<Node>) {
        self.recv = recv;
    }

    /// Sets `operator` field
    pub fn set_operator(&mut self, operator: String) {
        self.operator = operator;
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalOpAsgn {
        let Self { recv, operator, value, operator_l, expression_l,  } = self;
        super::InternalOpAsgn { recv, operator, value, operator_l, expression_l,  }
    }
}

impl InnerNode for OpAsgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_recv());
        result.push_str(self.get_operator());
        result.push_node(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "op_asgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().inner_ref().print_with_locs();

        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
