// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalOpAsgn;
use crate::blobs::{HasBlob, Blob};

/// Represents an operation with assignment (e.g. `a += 1`)
#[repr(C)]
pub struct OpAsgn {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for OpAsgn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("OpAsgn")
            .field("recv", &self.get_recv())
            .field("operator", &self.get_operator())
            .field("value", &self.get_value())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for OpAsgn {
    fn eq(&self, other: &Self) -> bool {
        if self.get_recv() != other.get_recv() {
            return false
        }
        if self.get_operator() != other.get_operator() {
            return false
        }
        if self.get_value() != other.get_value() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl OpAsgn {
    // getters
    /// Returns `recv` field
    pub fn get_recv(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__op_asgn__get_recv(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator` field
    pub fn get_operator(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__op_asgn__get_operator(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `value` field
    pub fn get_value(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__op_asgn__get_value(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__op_asgn__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__op_asgn__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__set_recv(&mut self.blob, recv.into_blob()) }
    }
    /// Sets `operator` field
    pub fn set_operator(&mut self, operator: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__set_operator(&mut self.blob, operator.into_blob()) }
    }
    /// Sets `value` field
    pub fn set_value(&mut self, value: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__set_value(&mut self.blob, value.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalOpAsgn {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__op_asgn__get_recv(blob: *const Blob<OpAsgn>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__op_asgn__set_recv(blob: *mut Blob<OpAsgn>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__op_asgn__get_operator(blob: *const Blob<OpAsgn>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__op_asgn__set_operator(blob: *mut Blob<OpAsgn>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__op_asgn__get_value(blob: *const Blob<OpAsgn>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__op_asgn__set_value(blob: *mut Blob<OpAsgn>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__op_asgn__get_operator_l(blob: *const Blob<OpAsgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__op_asgn__set_operator_l(blob: *mut Blob<OpAsgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__op_asgn__get_expression_l(blob: *const Blob<OpAsgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__op_asgn__set_expression_l(blob: *mut Blob<OpAsgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__op_asgn__into_internal(blob: Blob<OpAsgn>) -> InternalOpAsgn;
    fn lib_ruby_parser__external__nodes__op_asgn__drop(blob: *mut Blob<OpAsgn>);
}

impl InnerNode for OpAsgn {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_recv());
        result.push_str(self.get_operator());
        result.push_node(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "op_asgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().inner_ref().print_with_locs();

        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for OpAsgn {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__op_asgn__drop(&mut self.blob) }
    }
}
