// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents module declaration using `module` keyword
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Module {
    /// Name of the module
    pub name: Box<Node>,

    /// Body of the module
    ///
    /// `None` if module has no body
    pub body: Option<Box<Node>>,

    /// Location of the `module` keyword
    ///
    /// ```text
    /// module M; end
    /// ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// module M; end
    ///           ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// module M; end
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Module {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &Box<Node> {
        &self.name
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: Box<Node>) {
        self.name = name;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalModule {
        let Self { name, body, keyword_l, end_l, expression_l,  } = self;
        super::InternalModule { name, body, keyword_l, end_l, expression_l,  }
    }
}

impl InnerNode for Module {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_name());
        result.push_maybe_node_or_nil(self.get_body());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "module"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_name().inner_ref().print_with_locs();
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
