// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalModule;
use crate::blobs::{HasBlob, Blob};

/// Represents module declaration using `module` keyword
#[repr(C)]
pub struct Module {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Module {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Module")
            .field("name", &self.get_name())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Module {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_body() != other.get_body() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Module {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__module__get_name(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `body` field
    pub fn get_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__module__get_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__module__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__module__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__module__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__module__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `body` field
    pub fn set_body(&mut self, body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__module__set_body(&mut self.blob, body.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__module__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__module__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__module__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalModule {
        unsafe { lib_ruby_parser__external__nodes__module__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__module__get_name(blob: *const Blob<Module>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__module__set_name(blob: *mut Blob<Module>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__module__get_body(blob: *const Blob<Module>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__module__set_body(blob: *mut Blob<Module>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__module__get_keyword_l(blob: *const Blob<Module>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__module__set_keyword_l(blob: *mut Blob<Module>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__module__get_end_l(blob: *const Blob<Module>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__module__set_end_l(blob: *mut Blob<Module>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__module__get_expression_l(blob: *const Blob<Module>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__module__set_expression_l(blob: *mut Blob<Module>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__module__into_internal(blob: Blob<Module>) -> InternalModule;
    fn lib_ruby_parser__external__nodes__module__drop(blob: *mut Blob<Module>);
}

impl InnerNode for Module {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_name());
        result.push_maybe_node_or_nil(self.get_body());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "module"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_name().inner_ref().print_with_locs();
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Module {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__module__drop(&mut self.blob) }
    }
}
