// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalMatchNilPattern;
use crate::blobs::{HasBlob, Blob};

/// Represents empty hash pattern that is used in pattern matching (i.e. `in **nil`)
#[repr(C)]
pub struct MatchNilPattern {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for MatchNilPattern {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("MatchNilPattern")
            .field("operator_l", &self.get_operator_l())
            .field("name_l", &self.get_name_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for MatchNilPattern {
    fn eq(&self, other: &Self) -> bool {
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_name_l() != other.get_name_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl MatchNilPattern {
    // getters
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_nil_pattern__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_nil_pattern__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_nil_pattern__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_nil_pattern__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_nil_pattern__set_name_l(&mut self.blob, name_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_nil_pattern__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalMatchNilPattern {
        unsafe { lib_ruby_parser__external__nodes__match_nil_pattern__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__match_nil_pattern__get_operator_l(blob: *const Blob<MatchNilPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_nil_pattern__set_operator_l(blob: *mut Blob<MatchNilPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_nil_pattern__get_name_l(blob: *const Blob<MatchNilPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_nil_pattern__set_name_l(blob: *mut Blob<MatchNilPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_nil_pattern__get_expression_l(blob: *const Blob<MatchNilPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_nil_pattern__set_expression_l(blob: *mut Blob<MatchNilPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_nil_pattern__into_internal(blob: Blob<MatchNilPattern>) -> InternalMatchNilPattern;
    fn lib_ruby_parser__external__nodes__match_nil_pattern__drop(blob: *mut Blob<MatchNilPattern>);
}

impl InnerNode for MatchNilPattern {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_nil_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_operator_l().print("operator");
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}

impl Drop for MatchNilPattern {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__match_nil_pattern__drop(&mut self.blob) }
    }
}
