// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalMatchCurrentLine;
use crate::blobs::{HasBlob, Blob};

/// Represents implicit matching using `if /regex/`
///
/// ```text
/// if /.*/
/// puts 'true'
/// else
/// puts 'false'
/// end
/// ```
/// Prints "false".
///
/// Under the hood this construction matches regex against `$_`, so the following works:
/// ```text
/// $_ = 'match_me'
/// if /match_me/
/// puts 'true'
/// else
/// puts 'false'
/// end
/// ```
/// this code prints "true".
#[repr(C)]
pub struct MatchCurrentLine {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for MatchCurrentLine {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("MatchCurrentLine")
            .field("re", &self.get_re())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for MatchCurrentLine {
    fn eq(&self, other: &Self) -> bool {
        if self.get_re() != other.get_re() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl MatchCurrentLine {
    // getters
    /// Returns `re` field
    pub fn get_re(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_current_line__get_re(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_current_line__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `re` field
    pub fn set_re(&mut self, re: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__match_current_line__set_re(&mut self.blob, re.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_current_line__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalMatchCurrentLine {
        unsafe { lib_ruby_parser__external__nodes__match_current_line__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__match_current_line__get_re(blob: *const Blob<MatchCurrentLine>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__match_current_line__set_re(blob: *mut Blob<MatchCurrentLine>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__match_current_line__get_expression_l(blob: *const Blob<MatchCurrentLine>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_current_line__set_expression_l(blob: *mut Blob<MatchCurrentLine>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_current_line__into_internal(blob: Blob<MatchCurrentLine>) -> InternalMatchCurrentLine;
    fn lib_ruby_parser__external__nodes__match_current_line__drop(blob: *mut Blob<MatchCurrentLine>);
}

impl InnerNode for MatchCurrentLine {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_re());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_current_line"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_re().inner_ref().print_with_locs();
        self.get_expression_l().print("expression");
    }
}

impl Drop for MatchCurrentLine {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__match_current_line__drop(&mut self.blob) }
    }
}
