// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalMasgn;
use crate::blobs::{HasBlob, Blob};

/// Represents mass-assignment (i.e. `foo, bar = 1, 2`)
#[repr(C)]
pub struct Masgn {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Masgn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Masgn")
            .field("lhs", &self.get_lhs())
            .field("rhs", &self.get_rhs())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Masgn {
    fn eq(&self, other: &Self) -> bool {
        if self.get_lhs() != other.get_lhs() {
            return false
        }
        if self.get_rhs() != other.get_rhs() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Masgn {
    // getters
    /// Returns `lhs` field
    pub fn get_lhs(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__masgn__get_lhs(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `rhs` field
    pub fn get_rhs(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__masgn__get_rhs(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__masgn__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__masgn__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `lhs` field
    pub fn set_lhs(&mut self, lhs: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__masgn__set_lhs(&mut self.blob, lhs.into_blob()) }
    }
    /// Sets `rhs` field
    pub fn set_rhs(&mut self, rhs: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__masgn__set_rhs(&mut self.blob, rhs.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__masgn__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__masgn__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalMasgn {
        unsafe { lib_ruby_parser__external__nodes__masgn__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__masgn__get_lhs(blob: *const Blob<Masgn>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__masgn__set_lhs(blob: *mut Blob<Masgn>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__masgn__get_rhs(blob: *const Blob<Masgn>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__masgn__set_rhs(blob: *mut Blob<Masgn>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__masgn__get_operator_l(blob: *const Blob<Masgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__masgn__set_operator_l(blob: *mut Blob<Masgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__masgn__get_expression_l(blob: *const Blob<Masgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__masgn__set_expression_l(blob: *mut Blob<Masgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__masgn__into_internal(blob: Blob<Masgn>) -> InternalMasgn;
    fn lib_ruby_parser__external__nodes__masgn__drop(blob: *mut Blob<Masgn>);
}

impl InnerNode for Masgn {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_lhs());
        result.push_node(self.get_rhs());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "masgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_lhs().inner_ref().print_with_locs();
        self.get_rhs().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Masgn {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__masgn__drop(&mut self.blob) }
    }
}
