// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents an special argument that rejects all keyword arguments (i.e. `def m(**nil); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwnilarg {
    /// Location of the `nil`
    ///
    /// ```text
    /// def m(**nil); end
    ///         ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `nil`
    ///
    /// ```text
    /// def m(**nil); end
    ///       ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Kwnilarg {
    // getters

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwnilarg {
        let Self { name_l, expression_l,  } = self;
        super::InternalKwnilarg { name_l, expression_l,  }
    }
}

impl InnerNode for Kwnilarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwnilarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}
