// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents kwargs that are given to a method call, super or yield (i.e. `foo(bar: 1)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwargs {
    /// A list of key-value pairs
    pub pairs: Vec<Node>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo(bar: 1)
    ///     ~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Kwargs {
    // getters

    /// Returns `pairs` field
    pub fn get_pairs(&self) -> &Vec<Node> {
        &self.pairs
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `pairs` field
    pub fn set_pairs(&mut self, pairs: Vec<Node>) {
        self.pairs = pairs;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwargs {
        let Self { pairs, expression_l,  } = self;
        super::InternalKwargs { pairs, expression_l,  }
    }
}

impl InnerNode for Kwargs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_pairs());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwargs"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_pairs().iter() { node.inner_ref().print_with_locs(); }
        self.get_expression_l().print("expression");
    }
}
