// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;

use super::internal::InternalKwargs;
use crate::blobs::{HasBlob, Blob};

/// Represents kwargs that are given to a method call, super or yield (i.e. `foo(bar: 1)`)
#[repr(C)]
pub struct Kwargs {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Kwargs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Kwargs")
            .field("pairs", &self.get_pairs())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Kwargs {
    fn eq(&self, other: &Self) -> bool {
        if self.get_pairs() != other.get_pairs() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Kwargs {
    // getters
    /// Returns `pairs` field
    pub fn get_pairs(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwargs__get_pairs(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwargs__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `pairs` field
    pub fn set_pairs(&mut self, pairs: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__kwargs__set_pairs(&mut self.blob, pairs.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwargs__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalKwargs {
        unsafe { lib_ruby_parser__external__nodes__kwargs__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__kwargs__get_pairs(blob: *const Blob<Kwargs>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__kwargs__set_pairs(blob: *mut Blob<Kwargs>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__kwargs__get_expression_l(blob: *const Blob<Kwargs>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwargs__set_expression_l(blob: *mut Blob<Kwargs>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwargs__into_internal(blob: Blob<Kwargs>) -> InternalKwargs;
    fn lib_ruby_parser__external__nodes__kwargs__drop(blob: *mut Blob<Kwargs>);
}

impl InnerNode for Kwargs {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_pairs());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwargs"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_pairs().iter() { node.inner_ref().print_with_locs(); }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Kwargs {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__kwargs__drop(&mut self.blob) }
    }
}
