// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalKwarg;
use crate::blobs::{HasBlob, Blob};

/// Represents required keyword argument (i.e. `foo` in `def m(foo:); end`)
#[repr(C)]
pub struct Kwarg {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Kwarg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Kwarg")
            .field("name", &self.get_name())
            .field("name_l", &self.get_name_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Kwarg {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_name_l() != other.get_name_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Kwarg {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwarg__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwarg__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwarg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__kwarg__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwarg__set_name_l(&mut self.blob, name_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwarg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalKwarg {
        unsafe { lib_ruby_parser__external__nodes__kwarg__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__kwarg__get_name(blob: *const Blob<Kwarg>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__kwarg__set_name(blob: *mut Blob<Kwarg>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__kwarg__get_name_l(blob: *const Blob<Kwarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwarg__set_name_l(blob: *mut Blob<Kwarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwarg__get_expression_l(blob: *const Blob<Kwarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwarg__set_expression_l(blob: *mut Blob<Kwarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwarg__into_internal(blob: Blob<Kwarg>) -> InternalKwarg;
    fn lib_ruby_parser__external__nodes__kwarg__drop(blob: *mut Blob<Kwarg>);
}

impl InnerNode for Kwarg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Kwarg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__kwarg__drop(&mut self.blob) }
    }
}
