// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalIfGuard;
use crate::blobs::{HasBlob, Blob};

/// Represents an `if` guard used in pattern matching (i.e. `case foo; in pattern if guard; end`)
#[repr(C)]
pub struct IfGuard {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for IfGuard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("IfGuard")
            .field("cond", &self.get_cond())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for IfGuard {
    fn eq(&self, other: &Self) -> bool {
        if self.get_cond() != other.get_cond() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl IfGuard {
    // getters
    /// Returns `cond` field
    pub fn get_cond(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_guard__get_cond(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_guard__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_guard__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_guard__set_cond(&mut self.blob, cond.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_guard__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_guard__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIfGuard {
        unsafe { lib_ruby_parser__external__nodes__if_guard__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__if_guard__get_cond(blob: *const Blob<IfGuard>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__if_guard__set_cond(blob: *mut Blob<IfGuard>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__if_guard__get_keyword_l(blob: *const Blob<IfGuard>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_guard__set_keyword_l(blob: *mut Blob<IfGuard>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_guard__get_expression_l(blob: *const Blob<IfGuard>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_guard__set_expression_l(blob: *mut Blob<IfGuard>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_guard__into_internal(blob: Blob<IfGuard>) -> InternalIfGuard;
    fn lib_ruby_parser__external__nodes__if_guard__drop(blob: *mut Blob<IfGuard>);
}

impl InnerNode for IfGuard {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if_guard"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for IfGuard {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__if_guard__drop(&mut self.blob) }
    }
}
