// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if` statement (i.e. `if foo; bar; else; baz; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct If {
    /// Condition given to the `if` statement, `Lvar("a")` for `if a; b; else; c; end`
    pub cond: Box<Node>,

    /// True-branch of the `if` statement, `Lvar("b")` for `if a; b; else; c; end`
    pub if_true: Option<Box<Node>>,

    /// False-branch of the `if` statement, `Lvar("c")` for `if a; b; else; c; end`
    pub if_false: Option<Box<Node>>,

    /// Location of the `if` keyword
    ///
    /// ```text
    /// if foo; end
    /// ~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// if foo then; end
    ///        ~~~~
    /// ```
    ///
    /// `None` if `then` keyword is omitted
    pub begin_l: Loc,

    /// Location of the `else` keyword
    ///
    /// ```text
    /// if foo; else; end
    ///         ~~~~
    /// ```
    ///
    /// `None` if there's no `else` branch
    pub else_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// if foo; end
    ///         ~~~
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// if a then; b; else; c end
    /// ~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl If {
    // getters

    /// Returns `cond` field
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    /// Returns `if_true` field
    pub fn get_if_true(&self) -> &Option<Box<Node>> {
        &self.if_true
    }

    /// Returns `if_false` field
    pub fn get_if_false(&self) -> &Option<Box<Node>> {
        &self.if_false
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &Option<Loc> {
        &self.else_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Box<Node>) {
        self.cond = cond;
    }

    /// Sets `if_true` field
    pub fn set_if_true(&mut self, if_true: Option<Box<Node>>) {
        self.if_true = if_true;
    }

    /// Sets `if_false` field
    pub fn set_if_false(&mut self, if_false: Option<Box<Node>>) {
        self.if_false = if_false;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: Option<Loc>) {
        self.else_l = else_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIf {
        let Self { cond, if_true, if_false, keyword_l, begin_l, else_l, end_l, expression_l,  } = self;
        super::InternalIf { cond, if_true, if_false, keyword_l, begin_l, else_l, end_l, expression_l,  }
    }
}

impl InnerNode for If {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_maybe_node_or_nil(self.get_if_true());
        result.push_maybe_node_or_nil(self.get_if_false());





        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        if let Some(node) = self.get_if_true().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_if_false().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        if let Some(loc) = self.get_else_l().as_ref() { loc.print("else") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
